﻿
CREATE PROCEDURE [App].[NVCC_usp_GetVAMeds]
	@pid bigint -- this is the patientsid

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler (Original script by Dr. Charles Demosthenes)
--Object/SP Name		: NVCC_usp_GetVAMeds
--SERVER				: 
--Data Base				: CC_REFDOC
--Schema				: App
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 02-04-2016
--
--Last Changed          : 08-23-2016
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Users registering complaints that REFDOC is not showing
--                        the same number of current prescriptions as CPRS.
--                        After a meeting with Judy & Dr. D they had us change
--                        the criteria to all prescriptions released over the last
--                        year regardless of status or currently taking (see
--                        comments embedded below)
--
--Last Changed          : 08-22-2016
--Last Changed By		: Brian Diggs - Northwest Innovation Center (NWIC)
--Reason For Change		: Reconciled with version on server.
--                        Updated documentation and creation/signing standards
--               		: Removed station parameter in order to expand the search
--                        for a patient's VA meds from a single station to any
--                        station a patient is associated with.
--
--Purpose               : Retrieve a patient's medications issued by VA for
--                        inclusion into NVCC documentation
--=================================================================================


BEGIN
    -- SET NOCOUNT ON added to prevent extra result sets from
    -- interfering with SELECT statements.
    SET NOCOUNT ON;

    WITH MyDrugs AS
       (
--      declare @PID int = 1000862763
--      select PTSid from [App].[udf_AllPatientsSIDs](@pid)
        SELECT ROF.Sta3n
              ,ROF.[RxOutpatSID]
              ,ROF.[FillNumber]
              ,RO.[RxStatus]
              ,ROF.[LocalDrugNameWithDose]
              ,ROF.[IssueDate]
              ,ROF.[FillDateTime]
			  ,RO.NextPossibleFillDate
              ,ROF.[Qty]
              ,ROF.[DaysSupply]
			  ,RO.[MaxRefills]
              ,Row_Number() OVER(partition by ROF.[LocalDrugNameWithDose] Order by ROF.[FillDateTime] desc) AS Rn
        FROM [CDWWork].[RxOut].[RxOutpatFill] ROF
			INNER JOIN CDWWork.RxOut.RxOutpat AS RO
				ON ROF.RxOutpatSID = RO.RxOutpatSID
        WHERE ROF.PatientSID in (select PtSID from [App].[udf_AllPatientsSIDs](@pid)) 
          AND (ReleaseDateTime > dateadd(year, -1, SYSDATETIME()))
		  AND ReleaseDateTime IS NOT NULL
       )
    
        SELECT dl.Sta3n
              ,dl.rxoutpatsid
              ,dl.localdrugnamewithdose
              ,cast(dl.filldatetime as date) as filldate
              ,dl.qty as qty
              ,dl.FillNumber
              ,sig.Sig
              ,dl.issuedate
			  ,ISNULL(cast(dl.NextPossibleFillDate as varchar), 'N/A') as nextpossiblefilldate
			  ,ISNULL(dl.maxrefills, '0') as maxrefills
			  ,dl.DaysSupply AS dayssupply
			  ,dl.RxStatus
        FROM MyDrugs dl
        INNER JOIN CDWWork.RxOut.RxOutpatSig sig on dl.Rxoutpatsid=sig.RxOutpatSID
        WHERE dl.Rn = 1
    ORDER BY dl.RxStatus, dl.FillDateTime desc;
    
END;

